<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    public function streams()
    {
        return $this->hasMany('App\Models\Stream', 'event_id');
    }

    public function speakers()
    {
        return $this->hasMany('App\Models\Speaker', 'event_id');
    }

    public function rooms()
    {
        return $this->hasMany('App\Models\Room', 'event_id');
    }

    public function chatRoom()
    {
        return $this->hasOne('App\Models\GroupChatRoom', 'event_id');
    }

    public function contentLibraryGroups()
    {
        return $this->hasMany('App\Models\ContentLibraryGroup', 'event_id')->orderBy('display_order');
    }

    public function attendees()
    {
        return $this->belongsToMany('App\Models\User', 'event_attendance')->as('event_attendance')->withPivot('attending')->withTimestamps();
    }

}